<link rel="stylesheet" href="<?php echo base_url(); ?>assets/js/jquery-ui/css/smoothness/jquery-ui-1.9.2.custom.css"/>
<script type="text/javascript" src="<?php echo base_url() ?>assets/js/jquery-ui/js/jquery-ui-1.9.2.custom.js"></script>
<script src="<?php echo base_url() ?>assets/js/sweetalert2.all.min.js"></script>
<script src="<?php echo base_url() ?>assets/js/dayjs.min.js"></script>

<?php $situacao = $this->input->get('situacao');
$periodo = $this->input->get('periodo');
?>

<style type="text/css">
    label.error {
        color: #b94a48;
    }

    input.error {
        border-color: #b94a48;
    }

    input.valid {
        border-color: #5bb75b;
    }

    textarea {
        resize: vertical;
    }
</style>


<?php if ($this->permission->checkPermission($this->session->userdata('permissao'), 'aLancamento')) { ?>
    <div class="span5" style="margin-left: 0">
        <a href="#modalReceita" data-toggle="modal" role="button" class="btn btn-success tip-bottom"
           title="Cadastrar nova receita"><i class="fas fa-plus"></i> Receita</a>
        <a href="#modalDespesa" data-toggle="modal" role="button" class="btn btn-danger tip-bottom"
           title="Cadastrar nova despesa"><i class="fas fa-plus"></i> Despesa </a>
	<a href="https://conta.stone.com.br/login" target="new"role="button" class="button btn btn-mini btn-warning" title="edlsd@me.com"> Conta Stone</a></div>
<?php } ?>

<div class="span12" style="margin-left: 0;margin-top: 1rem;">
    <form action="<?php echo current_url(); ?>" method="get">
        <div class="span2" style="margin-left: 0">
            <a title="Visualizar OS" class="btn btn-mini btn-inverse"></i> Periodo</a>
            <select id="periodo" name="periodo" class="span12">
                <option value="dia" <?= $this->input->get('periodo') === 'dia' ? 'selected' : '' ?>>Dia</option>
                <option value="semana" <?= $this->input->get('periodo') === 'semana' ? 'selected' : '' ?>>Semana
                </option>
                <option value="mes" <?= $this->input->get('periodo') === 'mes' ? 'selected' : '' ?>>Mês</option>
                <option value="ano" <?= $this->input->get('periodo') === 'ano' ? 'selected' : '' ?>>Ano</option>
            </select>
        </div>

        <div class="span2">
             <a title="Visualizar OS" class="btn btn-mini btn-inverse"></i> Filtrar Inicio</a>
          <input id="vencimento_de" type="text" class="span12 datepicker" name="vencimento_de"
                   value="<?= $this->input->get('vencimento_de') ? $this->input->get('vencimento_de') : date('d/m/Y') ?>">
        </div>

        <div class="span2">
            <a title="Visualizar OS" class="btn btn-mini btn-inverse"></i> Filtrar Final</a>
            <input id="vencimento_ate" type="text" class="span12 datepicker" name="vencimento_ate"
                   value="<?= $this->input->get('vencimento_ate') ? $this->input->get('vencimento_ate') : date('d/m/Y') ?>">
        </div>

        <div class="span2">
            <a title="Visualizar OS" class="btn btn-mini btn-inverse"></i> Tipo</a>
            <select name="tipo" class="span12">
                <option value="">Todos</option>
                <option value="receita" <?= $this->input->get('tipo') === 'receita' ? 'selected' : '' ?>>Receita
                </option>
                <option value="despesa" <?= $this->input->get('tipo') === 'despesa' ? 'selected' : '' ?>>Despesa
                </option>
            </select>
        </div>

        <div class="span2">
           <a title="Visualizar OS" class="btn btn-mini btn-inverse"></i> Status</a>
            <select name="status" class="span12">
                <option value="">Todos</option>
                <option value="0" <?= $this->input->get('status') === '0' ? 'selected' : '' ?>>Pendente</option>
                <option value="1" <?= $this->input->get('status') === '1' ? 'selected' : '' ?>>Pago</option>
            </select>
        </div>

         <div class="span2">

           <a title="Visualizar OS" class="btn btn-mini btn-inverse"></i> Forma Pgto</a>
            <input id="formaPgto" type="text" class="span12" name="formaPgto" value="<?= $this->input->get('forma_pgto') ?>">
         <button type="submit" class="span12 btn btn-primary btn-sm" style="margin-top: 0.3rem;">Filtrar</button>

            
        </div>
    </form>
</div>

<div class="span12" style="margin-left: 0;">
    <div class="widget-box">
        <div class="widget-title">
      <span class="icon">
        <i class="fas fa-hand-holding-usd"></i>
      </span>
            <h5>Lançamentos Financeiros</h5>

        </div>

        <div class="widget-content nopadding tab-content">


            <table class="table table-bordered " id="divLancamentos">
                <thead>
                <tr style="background-color: #99b6ff">
                    <th>#</th>
                    <th>Tipo</th>
                    <th>Descrição/Cliente </th>
                    <th>Tipo da entrada</th>
                    <th>Vencimento</th>
                    <th>Status</th>
                    <th>Movimento</th>
                    <th>Valor</th>
                    <th>Ações</th>
                </tr>
                </thead>
                <tbody>
                <?php

                if (!$results) {
                    echo '<tr>
              <td colspan="8" >Nenhum lançamento encontrado</td>
            </tr>';
                }
                foreach ($results as $r) {
                    $vencimento = date(('d/m/Y'), strtotime($r->data_vencimento));
                    if ($r->baixado == 0) {
                        $status = 'Pendente';
                    } else {
                        $status = 'Pago';
                    };
                    if ($r->tipo == 'receita') {
                        $label = 'success';
                    } else {
                        $label = 'important';
                    }
                    echo '<tr>';
                    echo '<td>' . $r->idLancamentos . '</td>';
                    echo '<td><span class="label label-' . $label . '">' . ucfirst($r->tipo) . '</span></td>';
                    echo '<td>' . $r->cliente_fornecedor . '</td>';
                    echo '<td>' . $r->descricao . '</td>';
                    echo '<td>' . $vencimento . '</td>';
                    echo '<td>' . $status . '</td>';
                    echo '<td>' . $r->forma_pgto . '</td>';
                    echo '<td> R$ ' . number_format($r->valor, 2, ',', '.') . '</td>';
                    echo '<td>';
                    if ($this->permission->checkPermission($this->session->userdata('permissao'), 'eLancamento')) {
                        echo '<a href="#modalEditar" style="margin-right: 1%" data-toggle="modal" role="button" idLancamento="' . $r->idLancamentos . '" descricao="' . $r->descricao . '" valor="' . $r->valor . '" vencimento="' . date('d/m/Y', strtotime($r->data_vencimento)) . '" pagamento="' . date('d/m/Y', strtotime($r->data_pagamento)) . '" baixado="' . $r->baixado . '" cliente="' . $r->cliente_fornecedor . '" formaPgto="' . $r->forma_pgto . '" tipo="' . $r->tipo . '" observacoes="' . $r->observacoes . '" usuario="' . $r->nome . '" class="btn btn-info tip-top editar" title="Editar Lançamento"><i class="fas fa-edit"></i></a>';
                    }
                    if ($this->permission->checkPermission($this->session->userdata('permissao'), 'dLancamento')) {
                        echo '<a href="#modalExcluir" data-toggle="modal" role="button" idLancamento="' . $r->idLancamentos . '" class="btn btn-danger tip-top excluir" title="Excluir Lançamento"><i class="fas fa-trash-alt"></i></a>';
                    }

                    echo '</td>';
                    echo '</tr>';
                } ?>
                </tbody>
                <tfoot>
                <tr>
                    <td colspan="6" style="text-align: right; color: #00ff00"><strong>Total Receitas:</strong></td>
                    <td colspan="3" style="text-align: left; color: #00ff00">
                        <strong>R$ <?php echo number_format($totals['receitas'], 2, ',', '.') ?></strong></td>
                </tr>
                <tr>
                    <td colspan="6" style="text-align: right; color: #ff0000"><strong>Total Despesas:</strong></td>
                    <td colspan="3" style="text-align: left; color: #ff0000">
                        <strong>R$ <?php echo number_format($totals['despesas'], 2, ',', '.') ?></strong></td>
                </tr>
                <tr>
                    <td colspan="6" style="text-align: right"><strong>Saldo:</strong></td>
                    <td colspan="3" style="text-align: left;">
                        <strong>R$ <?php echo number_format($totals['receitas'] - $totals['despesas'], 2, ',', '.') ?></strong>
                    </td>
                </tr>
                </tfoot>
            </table>
        </div>
    </div>

</div>

<?php echo $this->pagination->create_links(); ?>


<!-- Modal nova receita -->
<div id="modalReceita" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
     aria-hidden="true">
    <form id="formReceita" action="<?php echo base_url() ?>index.php/financeiro/adicionarReceita" method="post">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            <h4 id="myModalLabel">Adicionar Receita</h4>
        </div>
        <div class="modal-body">

            <div class="span12 alert alert-info" style="margin-left: 0"> Obrigatório o preenchimento dos campos com
                asterisco.
            </div>
            <div class="span12" style="margin-left: 0">
                <label for="descricao">Tipo da Receita</label>
                <input class="span12" id="descricao" type="text" name="descricao" value="LANÇAMENTO"readonly="">
                <input id="urlAtual" type="hidden" name="urlAtual" value="<?php echo current_url() ?>"/>
            </div>
            <div class="span12" style="margin-left: 0">
                <div class="span12" style="margin-left: 0">
                    <label for="cliente">Descrição/Cliente*</label>
                    <input class="span12" id="cliente" type="text" name="cliente"/>
                    <input class="span12" id="idCliente" type="hidden" name="idCliente"/>
                </div>

                <div class="span12" style="margin-left: 0"></div>

            </div>
            <div class="span12" style="margin-left: 0">
                <div class="span4" style="margin-left: 0">
                    <label for="valor">Valor*</label>
                    <input type="hidden" id="tipo" name="tipo" value="receita"/>
                    <input class="span12 money" id="valor" type="text" name="valor"/>
                </div>
                <?php if ($this->permission->checkPermission($this->session->userdata('permissao'), 'dLancamento')) { ?>
                <div class="span4">
                    <label for="vencimento">Data Vencimento*</label>
                    <input class="span12 datepicker" autocomplete="off" id="vencimento" type="text" name="vencimento"
					value="<?= $this->input->get('vencimento') ? $this->input->get('vencimento') : date('d/m/Y') ?>"/>
                </div>
			<?php } else { ?>
				<div class="span4">
                    <label for="vencimento">Data Vencimento*</label>
                    <input class="span12 datepicker" disabled="true" autocomplete="off" id="vencimento" type="text" name="vencimento"
					value="<?= $this->input->get('vencimento') ? $this->input->get('vencimento') : date('d/m/Y') ?>"/>
                </div>
			<?php } ?>

            </div>
            <div class="span12" style="margin-left: 0">
                <div class="span4" style="margin-left: 0">
                    <label for="recebido">Recebido?</label>
                    &nbsp &nbsp &nbsp &nbsp<input id="recebido" type="checkbox" name="recebido" value="1"/>
                </div>
                <div id="divRecebimento" class="span8" style=" display: none">
                    <?php if ($this->permission->checkPermission($this->session->userdata('permissao'), 'dLancamento')) { ?>	
                    <div class="span6">
                        <label for="recebimento">Data Recebimento</label>
                        <input class="span12 datepicker" autocomplete="off" id="recebimento" type="text" name="recebimento"
						value="<?= $this->input->get('recebimento') ? $this->input->get('recebimento') : date('d/m/Y') ?>"/>	
                    </div>
					<?php } else { ?>
					<div class="span6">
                        <label for="recebimento">Data Recebimento</label>
                        <input class="span12 datepicker" disabled="true" autocomplete="off" id="recebimento" type="text" name="recebimento"
						value="<?= $this->input->get('recebimento') ? $this->input->get('recebimento') : date('d/m/Y') ?>"/>	
                    </div>
				<?php } ?>
                    <div class="span6">
                        <label for="formaPgto">Forma Pgto</label>
                        <select name="formaPgto" id="formaPgto" class="span12">
                            <option value="Cartão">Cartão</option>
                            <option value="Dinheiro">Dinheiro</option>
                            <option value="Pix">Pix</option>
                            
                            
                        </select>
                    </div>
                </div>

            </div>

        </div>
        <div class="modal-footer">
            <button class="btn" data-dismiss="modal" aria-hidden="true">Cancelar</button>
            <button class="btn btn-success">Adicionar Receita</button>
        </div>
    </form>
</div>

<!-- Modal nova despesa -->
<div id="modalDespesa" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
     aria-hidden="true">
    <form id="formDespesa" action="<?php echo base_url() ?>index.php/financeiro/adicionarDespesa" method="post">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            <h4 id="myModalLabel">Adicionar Despesa</h4>
        </div>
        <div class="modal-body">
            <div class="span12 alert alert-info" style="margin-left: 0"> Obrigatório o preenchimento dos campos com
                asterisco.
            </div>
            <div class="span12" style="margin-left: 0">
                <label for="descricao">Tipo da Despesa</label>
                <input class="span12" id="descricao" type="text" name="descricao" value="PAGAMENTO"readonly="">
                <input id="urlAtual" type="hidden" name="urlAtual" value="<?php echo current_url() ?>"/>
            </div>
            <div class="span12" style="margin-left: 0">
                <div class="span12" style="margin-left: 0">
                    <label for="fornecedor">Descrição/Beneficiário*</label>
                    <input class="span12" id="fornecedor" type="text" name="fornecedor"/>
                    <input class="span12" id="idFornecedor" type="hidden" name="idFornecedor"/>
                </div>

                <div class="span12" style="margin-left: 0"></div>

            </div>
            <div class="span12" style="margin-left: 0">
                <div class="span4" style="margin-left: 0">
                    <label for="valor">Valor*</label>
                    <input type="hidden" name="tipo" value="despesa"/>
                    <input class="span12 money" type="text" name="valor"/>
                </div>
                <?php if ($this->permission->checkPermission($this->session->userdata('permissao'), 'dLancamento')) { ?>
                <div class="span4">
                    <label for="vencimento">Data Vencimento*</label>
                    <input class="span12 datepicker" autocomplete="off" type="text" name="vencimento"
					value="<?= $this->input->get('vencimento') ? $this->input->get('vencimento') : date('d/m/Y') ?>"/>
                </div>
				<?php } else { ?>
				<div class="span4">
                    <label for="vencimento">Data Vencimento*</label>
                    <input class="span12 datepicker" disabled="true"  autocomplete="off" type="text" name="vencimento"
					value="<?= $this->input->get('vencimento') ? $this->input->get('vencimento') : date('d/m/Y') ?>"/>
                </div>
				<?php } ?>

            </div>
            <div class="span12" style="margin-left: 0">
                <div class="span4" style="margin-left: 0">
                    <label for="pago">Foi Pago?</label>
                    &nbsp &nbsp &nbsp &nbsp<input id="pago" type="checkbox" name="pago" value="1"/>
                </div>
                <div id="divPagamento" class="span8" style=" display: none">
                    <?php if ($this->permission->checkPermission($this->session->userdata('permissao'), 'dLancamento')) { ?>
                    <div class="span6">
                        <label for="pagamento">Data Pagamento</label>
                        <input class="span12 datepicker" autocomplete="off" id="pagamento" type="text" name="pagamento"
						value="<?= $this->input->get('pagamento') ? $this->input->get('pagamento') : date('d/m/Y') ?>"/>
                    </div>
					<?php } else { ?>
					<div class="span6">
                        <label for="pagamento">Data Pagamento</label>
                        <input class="span12 datepicker" disabled="true" autocomplete="off" id="pagamento" type="text" name="pagamento"
						value="<?= $this->input->get('pagamento') ? $this->input->get('pagamento') : date('d/m/Y') ?>"/>
                    </div>
				<?php } ?>

                    <div class="span6">
                        <label for="formaPgto">Destino do Pgto</label>
                        <select name="formaPgto" class="span12">
                            <option value="Despesas">Despesas</option>
                            <option value="Compras">Compras</option>
                            <option value="Impostos">Impostos</option>
                            <option value="Vale">Vale</option>
                            <option value="Doações">Doações</option>
                            
   
                            
                        </select>
                    </div>
                </div>

            </div>

        </div>
        <div class="modal-footer">
            <button class="btn" data-dismiss="modal" aria-hidden="true">Cancelar</button>
            <button class="btn btn-danger">Adicionar Despesa</button>
        </div>
    </form>
</div>


<!-- Modal editar lançamento -->
<div id="modalEditar" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
     aria-hidden="true">
    <form id="formEditar" action="<?php echo base_url() ?>index.php/financeiro/editar" method="post">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            <h4 id="myModalLabel">Editar Lançamento</h4>
        </div>
        <div class="modal-body">
            <div class="span12 alert alert-info" style="margin-left: 0"> Obrigatório o preenchimento dos campos com
                asterisco.
            </div>
            <div class="span12" style="margin-left: 0">
                <label for="descricao">Tipo do lançamento</label>
                <input class="span12" id="descricaoEditar" type="text" name="descricao"/>
                <input id="urlAtualEditar" type="hidden" name="urlAtual" value=""/>
            </div>
            <div class="span12" style="margin-left: 0">
                <div class="span12" style="margin-left: 0">
                    <label for="fornecedor">Descrição/Cliente*</label>
                    <input class="span12" id="fornecedorEditar" type="text" name="fornecedor"/>
                </div>

                <div class="span12" style="margin-left: 0"></div>
            </div>
            <div class="span12" style="margin-left: 0">
                <div class="span4" style="margin-left: 0">
                    <label for="valor">Valor*</label>
                    <input type="hidden" name="tipo" value="despesa"/>
                    <input type="hidden" id="idEditar" name="id" value=""/>
                    <input class="span12 money" type="text" name="valor" id="valorEditar"/>
                </div>
                <div class="span4">
                    <label for="vencimento">Data Vencimento*</label>
                    <input class="span12 datepicker" type="text" name="vencimento" id="vencimentoEditar"/>
                </div>
                <div class="span4">
                    <label for="vencimento">Tipo*</label>
                    <select class="span12" name="tipo" id="tipoEditar">
                        <option value="receita">Receita</option>
                        <option value="despesa">Despesa</option>
                    </select>
                </div>

            </div>
            <div class="span12" style="margin-left: 0">
                <div class="span4" style="margin-left: 0">
                    <label for="pago">Foi Pago?</label>
                    &nbsp &nbsp &nbsp &nbsp<input id="pagoEditar" type="checkbox" name="pago" value="1"/>
                </div>
                <div id="divPagamentoEditar" class="span8" style=" display: none">
                    <div class="span6">
                        <label for="pagamento">Data Pagamento</label>
                        <input class="span12 datepicker" id="pagamentoEditar" type="text" name="pagamento"/>
                    </div>

                    <div class="span6">
                        <label for="formaPgto">Forma/Destino Pgto</label>
                        <select name="formaPgto" id="formaPgtoEditar" class="span12">
                            <option value="Cartão">Cartão</option>
                            <option value="Dinheiro">Dinheiro</option>
                            <option value="Pix">Pix</option>
							<option value="Despesas">Despesas</option>
                            <option value="Compras">Compras</option>
                            <option value="Impostos">Impostos</option>
                            <option value="Vale">Vale</option>
                            <option value="Doações">Doações</option>
                            
                        </select>
                    </div>
                </div>

            </div>

        </div>
        <div class="modal-footer">
            Modificado:<input disabled id="usuarioEditar" value=""/>
            <button class="btn" data-dismiss="modal" aria-hidden="true" id="btnCancelarEditar">Cancelar</button>
            <button class="btn btn-primary">Salvar Alterações</button>
        </div>
    </form>
</div>


<!-- Modal Excluir lançamento-->
<div id="modalExcluir" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
     aria-hidden="true">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
        <h4 id="myModalLabel">Excluir Lançamento</h4>
    </div>
    <div class="modal-body">
        <h5 style="text-align: center">Deseja realmente excluir esse lançamento?</h5>
        <input name="id" id="idExcluir" type="hidden" value=""/>
    </div>
    <div class="modal-footer">
        <button class="btn" data-dismiss="modal" aria-hidden="true" id="btnCancelExcluir">Cancelar</button>
        <button class="btn btn-danger" id="btnExcluir">Excluir Lançamento</button>
    </div>
</div>


<script src="<?php echo base_url() ?>assets/js/jquery.validate.js"></script>
<script src="<?php echo base_url(); ?>assets/js/maskmoney.js"></script>
<script type="text/javascript">
    jQuery(document).ready(function ($) {

        $(".money").maskMoney();

        $('#pago').click(function (event) {
            var flag = $(this).is(':checked');
            if (flag == true) {
                $('#divPagamento').show();
            } else {
                $('#divPagamento').hide();
            }
        });


        $('#recebido').click(function (event) {
            var flag = $(this).is(':checked');
            if (flag == true) {
                $('#divRecebimento').show();
            } else {
                $('#divRecebimento').hide();
            }
        });

        $('#pagoEditar').click(function (event) {
            var flag = $(this).is(':checked');
            if (flag == true) {
                $('#divPagamentoEditar').show();
            } else {
                $('#divPagamentoEditar').hide();
            }
        });


        $("#formReceita").validate({
            rules: {
                descricao: {
                    required: true
                },
                cliente: {
                    required: true
                },
                valor: {
                    required: true
                },
              

            },
            messages: {
                descricao: {
                    required: 'Campo Requerido.'
                },
                cliente: {
                    required: 'Campo Requerido.'
                },
                valor: {
                    required: 'Campo Requerido.'
                },
               
            }
        });


        $("#formDespesa").validate({
            rules: {
                descricao: {
                    required: true
                },
                fornecedor: {
                    required: true
                },
                valor: {
                    required: true
                },
             

            },
            messages: {
                descricao: {
                    required: 'Campo Requerido.'
                },
                fornecedor: {
                    required: 'Campo Requerido.'
                },
                valor: {
                    required: 'Campo Requerido.'
                },
              
            }
        });


        $(document).on('click', '.excluir', function (event) {
            $("#idExcluir").val($(this).attr('idLancamento'));
        });


        $(document).on('click', '.editar', function (event) {
            $("#idEditar").val($(this).attr('idLancamento'));
            $("#descricaoEditar").val($(this).attr('descricao'));
            $("#usuarioEditar").val($(this).attr('usuario'));
            $("#fornecedorEditar").val($(this).attr('cliente'));
            $("#observacoes_edit").val($(this).attr('observacoes'));
            $("#valorEditar").val($(this).attr('valor'));
            $("#vencimentoEditar").val($(this).attr('vencimento'));
            $("#pagamentoEditar").val($(this).attr('pagamento'));
            $("#formaPgtoEditar").val($(this).attr('formaPgto'));
            $("#tipoEditar").val($(this).attr('tipo'));
            $("#urlAtualEditar").val($(location).attr('href'));
            var baixado = $(this).attr('baixado');
            if (baixado == 1) {
                $("#pagoEditar").prop('checked', true);
                $("#divPagamentoEditar").show();
            } else {
                $("#pagoEditar").prop('checked', false);
                $("#divPagamentoEditar").hide();
            }


        });

        $(document).on('click', '#btnExcluir', function (event) {
            var id = $("#idExcluir").val();

            $.ajax({
                type: "POST",
                url: "<?php echo base_url(); ?>index.php/financeiro/excluirLancamento",
                data: "id=" + id,
                dataType: 'json',
                success: function (data) {
                    if (data.result == true) {
                        $("#btnCancelExcluir").trigger('click');
                        $("#divLancamentos").html('<div class="progress progress-striped active"><div class="bar" style="width: 100%;"></div></div>');
                        $("#divLancamentos").load($(location).attr('href') + " #divLancamentos");

                    } else {
                        $("#btnCancelExcluir").trigger('click');
                        Swal.fire({
                            type: "error",
                            title: "Atenção",
                            text: "Ocorreu um erro ao tentar excluir produto."
                        });
                    }
                }
            });
            return false;
        });
        let controlBaixa = "<?php echo $configuration['control_baixa']; ?>";
        let datePickerOptions = {
            dateFormat: 'dd/mm/yy',
        };
        if (controlBaixa === '1') {
            datePickerOptions.minDate = 0;
            datePickerOptions.maxDate = 0;
        }
        $(".datepicker2").datepicker(
            datePickerOptions
        );
        $(".datepicker").datepicker();
        $('#periodo').on('change', function (event) {
            const period = $('#periodo').val();

            switch (period) {
                case 'dia':
                    $('#vencimento_de').val(dayjs().locale('pt-br').format('DD/MM/YYYY'));
                    $('#vencimento_ate').val(dayjs().locale('pt-br').format('DD/MM/YYYY'));
                    break;
                case 'semana':
                    $('#vencimento_de').val(dayjs().startOf('week').locale('pt-br').format('DD/MM/YYYY'));
                    $('#vencimento_ate').val(dayjs().endOf('week').locale('pt-br').format('DD/MM/YYYY'));
                    break;
                case 'mes':
                    $('#vencimento_de').val(dayjs().startOf('month').locale('pt-br').format('DD/MM/YYYY'));
                    $('#vencimento_ate').val(dayjs().endOf('month').locale('pt-br').format('DD/MM/YYYY'));
                    break;
                case 'ano':
                    $('#vencimento_de').val(dayjs().startOf('year').locale('pt-br').format('DD/MM/YYYY'));
                    $('#vencimento_ate').val(dayjs().endOf('year').locale('pt-br').format('DD/MM/YYYY'));
                    break;
            }
        });

        $("#cliente_fornecedor").autocomplete({
            source: "<?php echo base_url(); ?>index.php/financeiro/autoCompleteClienteFornecedor",
            minLength: 1,
            select: function (event, ui) {
                $("#cliente_fornecedor").val(ui.item.value);
                $("#idFornecedor").val(ui.item.id);
            }
        });
        $("#cliente").autocomplete({
            source: "<?php echo base_url(); ?>index.php/financeiro/autoCompleteClienteAddReceita",
            minLength: 1,
            select: function (event, ui) {
                $("#cliente").val(ui.item.label);
                $("#idCliente").val(ui.item.id);
            }
        });
        $("#fornecedor").autocomplete({
            source: "<?php echo base_url(); ?>index.php/financeiro/autoCompleteClienteAddReceita",
            minLength: 1,
            select: function (event, ui) {
                $("#fornecedor").val(ui.item.label);
                $("#idFornecedor").val(ui.item.id);
            }
        });
		
    });
</script>
